/**
 *  \file   leds.c
 *  \brief  eZ430-RF2500 tutorial, leds
 *  \author Antoine Fraboulet, Tanguy Risset, Dominique Tournier
 *  \date   2009
 **/

#include <io.h>
#include <signal.h>
#include <iomacros.h>

#include "leds.h"


/* ************************************************** */
/* ************************************************** */
/* ************************************************** */

volatile int led_green = 0;
volatile int led_red   = 0;

/* ************************************************** */
/* ************************************************** */
/* ************************************************** */


#define LED_PORT       P1OUT

#define BIT_GREEN      (1 << 1)
#define BIT_RED        (1 << 0)

void led_green_off(void)
{
  LED_PORT &= ~BIT_GREEN;
  led_green = 0;
}

void led_green_on(void)
{
  LED_PORT |=  BIT_GREEN;
  led_green = 1;
}

void led_red_off(void)
{
  LED_PORT &= ~BIT_RED;
  led_red   = 0;
}

void led_red_on(void)
{
  LED_PORT |=  BIT_RED;
  led_red   = 1;
}

/* ************************************************** */
/* ************************************************** */
/* ************************************************** */

void LEDS_INIT(void)
{
  P1OUT  &= ~(BIT_GREEN | BIT_RED);
  P1DIR  |=  (BIT_GREEN | BIT_RED);
  P1SEL  &= ~(BIT_GREEN | BIT_RED);
  LEDS_OFF();
}

void LEDS_ON(void)
{
  LED_PORT |=  (BIT_GREEN | BIT_RED);
  led_red   = 1;
  led_green = 1;
}

void LEDS_OFF(void)
{
  LED_PORT &= ~(BIT_GREEN | BIT_RED);
  led_red   = 0;
  led_green = 0;
}

void SWITCH_RED_LED(void)
{
  if (led_red > 0)
    {
      LED_RED_OFF;
      led_red = 0;
    }
  else
    {
      LED_RED_ON;
      led_red = 1;
    }
}

void SWITCH_GREEN_LED(void)
{
  if (led_green > 0)
    {
      LED_GREEN_OFF;
      led_green = 0;
    }
  else
    {
      LED_GREEN_ON;
      led_green = 1;
    }
}

/* ************************************************** */
/* ************************************************** */
/* ************************************************** */

#define LED_DELAY 60000

#define LED_WAIT_LOOP(time)			\
  do {						\
    unsigned int n = time;			\
    /* 4 cycles loop */				\
    __asm__ __volatile__ (			\
			  "1: \n"		\
			  " dec   %[n] \n"	\
			  " jne   1b \n"	\
			  : [n] "+r"(n));	\
  } while (0)


#define LED_WAIT()				\
  do {						\
    LED_WAIT_LOOP(LED_DELAY);			\
    LED_WAIT_LOOP(LED_DELAY);			\
  } while (0)


void LED_BLINK_ME(void)
{
  while (1)
    {
      LED_RED_ON;
      LED_WAIT();
      LED_RED_OFF;
      LED_WAIT();
      LED_GREEN_ON;
      LED_WAIT();
      LED_GREEN_OFF;
      LED_WAIT();
    }
}

/* ************************************************** */
/* ************************************************** */
/* ************************************************** */

