tree grammar Java2C;
options{
  language=Java;
  tokenVocab=Ez430;
  ASTLabelType=CommonTree;
}

@header{
  package ez430;
  import java.util.Map;
  import java.util.HashMap;
  import java.util.Vector;
}


@members{
  private Map<String, String> driversProtos=new HashMap<String,String>();
  private Vector<String> initDrivers=new Vector<String>();
  private StringBuffer includedDrivers=new StringBuffer();
}

@init{
  driversProtos.put("switchGreenLed", "SWITCH_GREEN_LED");
}


compilationUnit returns [String result]
     : ('import' importDeclaration)* b=normalClassDeclaration EOF {result=includedDrivers.toString()+b;}
     ;

importDeclaration 
     : IDENTIFIER {includedDrivers.append("#include \""+$IDENTIFIER.text.toLowerCase()+".h\"\n");
		   initDrivers.add($IDENTIFIER.text.toUpperCase()+"_INIT();\n");
		  }
     ;

normalClassDeclaration returns [String result]
     : captorStatements {
                          StringBuffer sb=new StringBuffer();
                          for (String anInit: initDrivers){
			    sb.append("  "+anInit);
			  }
                          result="int main(void){\n"+ sb.toString()+ "  while(1){\n"+ $captorStatements.result+"\n  }\n  return 0;\n}\n";
			}
     ;

captorStatements returns [String result]
     : (blockStatement)* {result=$blockStatement.result;}
     ;

/*
methodDeclaration returns [String result]
     : a=type b=IDENTIFIER {result="  "+a+" "+b+"()";}
     ;

type returns [String result]
     :  'void' {result="void";}
     | 'boolean' {result="void";} 
     | 'char' {result="char";}
     | 'byte' {result="byte";}
     | 'short' {result="short";}
     | 'int' {result="int";}
     | 'long' {result="long";}
     | 'float' {result="float";}
     | 'double' {result="double";}
     | IDENTIFIER {result=$IDENTIFIER.text;}
     ;
*/     

blockStatement returns [String result]
     : IDENTIFIER {result="    "+driversProtos.get($IDENTIFIER.text)+"()";}
     ;
