package ez430;

import java.io.FileWriter;

import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;

import ez430.Ez430Parser.compilationUnit_return;

public class Test {
  public static void main(String[] args) throws Exception {
    ANTLRFileStream input = new ANTLRFileStream(args[0]);
    Ez430Lexer lexer = new Ez430Lexer(input);
    CommonTokenStream tokens = new CommonTokenStream(lexer);
    Ez430Parser parser = new Ez430Parser(tokens);
    compilationUnit_return compilUnit=parser.compilationUnit();

    System.out.println(compilUnit.tree.toStringTree());


    CommonTreeNodeStream nodeStream = new CommonTreeNodeStream(compilUnit.tree);
    Java2C walker = new Java2C(nodeStream);
    String result = walker.compilationUnit();

    FileWriter outputStream=new FileWriter("./main.c");
    System.out.println("ok - result =\n" + result);
    outputStream.write(result);
    outputStream.close();


  }
}

